/*****************************************************************************
* File:    main.c
*
* Purpose: Template for MC56F8006 verification software.
* Author:  Quinten Brooks, Freescale Semiconductor MCD IC Design - Phoenix
* Email:   quinten.brooks@freescale.com
* Date:    2007.06.01
* History:
*			Apr 16, modified by William Jiang
*
******************************************************************************
* Notes:   
*
*****************************************************************************/

#include "util.h"
#include "lib_sys.h"
#include "lib_sci.h"
#include "lib_utils.h"

extern void trim_rosc();


void delay(void);
void atualiza_l1(int8_t cor, int8_t intensidade);
void atualiza_l2(int8_t cor, int8_t intensidade);

int16_t i,j,k,tempo=60000;
int8_t intens=0;
/******************************************************************************
* pwm_ctrl(uint16_t mod, uint16_t v0, uint16_t v1, uint16_t v2)
*
* Enable PWM outputs in complimentary mode
******************************************************************************/
void pwm_ctrl(uint16_t mod, uint16_t v0, uint16_t v1, uint16_t v2)
{
    // Disable PWM
    PWM_CTRL &= ~PWM_CTRL_PWMEN;
    // Disable fault protection
    PWM_DMAP1 = 0;
    PWM_DMAP2 = 0;
    // Disable deadtime generators
    PWM_DTIM0 = 0;
    PWM_DTIM1 = 0;
    // Use complimentary mode
    PWM_CNFG &= ~(PWM_CNFG_INDEP01|PWM_CNFG_INDEP23|PWM_CNFG_INDEP45);
    // Set modulus (PWM period)
    PWM_CMOD = mod;
    // Set counter values (PWM duty cycle)
    PWM_VAL0 = v0;
    PWM_VAL1 = v0;
    PWM_VAL2 = v1;
    PWM_VAL3 = v1;
    PWM_VAL4 = v2;
    PWM_VAL5 = v2;
    // Enable PWM Outputs (set LDOK=1 before setting PWMEN=1)
    PWM_CTRL |= PWM_CTRL_LDOK;
    PWM_CTRL |= PWM_CTRL_PWMEN;    
    PWM_OUT = PWM_OUT_PAD_EN | PWM_OUT_OUT;
}


/*****************************************************************************
* void main ()
*****************************************************************************/
void main()
{
	int8_t c,i=0, dado;
	
    DisableWatchdog();
//    trim_rosc();
    enable_pll();
    
    // Configure gpio c1 as input, gpio c2 as output.
//	configure_A0A1_GPIO(); 
	   
    TERMIO_Init(4000l);//4800bps
    
    Print("*** A.W. APPNOTE ****\r\n");

    // Enable IPL0 interrupts, intialize ISR counters
//    asm(moveu.w #IPL0,sr);
//    pwm_reload_cnt = 0;
    
    // Enable PWM Peripheral Clock
    SIM_PCE |= SIM_PCE_PWM;
    
    
    ///////////////////////////////////////////////////////////////////////////
    // Use normal PWM output configuration
    //
    // PWM0 = GPIOA0
    // PWM1 = GPIOA1
    // PWM2 = GPIOA2
    // PWM3 = GPIOA3
    // PWM4 = GPIOA4
    // PWM5 = GPIOA5
    ///////////////////////////////////////////////////////////////////////////
    SIM_GPSA = 0;
    bitset(GPIOA_PER, BIT5+BIT4+BIT3+BIT2+BIT1+BIT0);
    
    ///////////////////////////////////////////////////////////////////////////
    // Test PWM channel swap with nBX = 0 and center aligned
    ///////////////////////////////////////////////////////////////////////////
  //  Print("CASE0: test PWM channel swap in independent mode with nBx = 0, center aligned\r\n");
    i = 1;
    pwm_reload_cnt = 0;

    PWM_CTRL &= ~(PWM_CTRL_PRSC);
    PWM_CTRL |= ((i-1) << 6);
  
    // Enable Reload Interrupts
    PWM_CTRL |= (PWM_CTRL_PWMRIE);

	// Enable Hardware Acceleration
	PWM_CCTRL |= PWM_CCTRL_ENHA;
	PWM_CCTRL &= ~(PWM_CCTRL_nBX);
	
	// Enable swap
	PWM_CCTRL |= (PWM_CCTRL_SWP45 | PWM_CCTRL_SWP23 | PWM_CCTRL_SWP01);
	
	// Disable edge aligned
	PWM_CNFG &= ~PWM_CNFG_EDG;
	PWM_CNFG |= (PWM_CNFG_INDEP01 | PWM_CNFG_INDEP23 | PWM_CNFG_INDEP45);

    // Set PWM frequency and duty cycle and enable PWM.
    //pwm_ctrl(100, 25, 50, 75);
    // Disable PWM
    PWM_CTRL &= ~PWM_CTRL_PWMEN;
    // Disable fault protection
    PWM_DMAP1 = 0;
    PWM_DMAP2 = 0;
    // Disable deadtime generators
    PWM_DTIM0 = 0;
    PWM_DTIM1 = 0;
    // Set modulus (PWM period)
    PWM_CMOD = 100;
    // Set counter values (PWM duty cycle)
    PWM_VAL0 = 20; // PA1 - pino11 - LED 2
    PWM_VAL1 = 0; // PA0 - pino9  - LED 1
    PWM_VAL2 = 0; // PA3 - pino32 - LED 4
    PWM_VAL3 = 0; // PA2 - pino30 - LED 3
    PWM_VAL4 = 20;// PA5 - pino36 - LED 6
    PWM_VAL5 = 0;// PA4 - pino34 - LED 5
    // Enable PWM Outputs (set LDOK=1 before setting PWMEN=1)
    PWM_CTRL |= PWM_CTRL_LDOK;
    PWM_CTRL |= PWM_CTRL_PWMEN;    
    PWM_OUT = PWM_OUT_PAD_EN | PWM_OUT_OUT;
	
	     
    //MB_PUT16(128, 0xFFFF);
    //WAIT_RE16(pwm_reload_cnt, 5, 0);
    Print("Digite alguma coisa:");
	while(1){
    	dado= TERMIO_GetChar();    
 
    
    if(dado=='@') {
      Print("Ok init\r\n");
    
      dado= TERMIO_GetChar();
      if(dado=='A') {
        Print("Setting LED1\r\n");
      
         dado= TERMIO_GetChar();
         atualiza_l1('R',dado);
         dado= TERMIO_GetChar();
         atualiza_l1('G',dado);
         dado= TERMIO_GetChar();
         atualiza_l1('B',dado);
         PWM_CTRL |= PWM_CTRL_LDOK;
      }
      if(dado=='B') {
        Print("Setting LED2\r\n");
      
         dado= TERMIO_GetChar();
         atualiza_l2('R',dado);
         dado= TERMIO_GetChar();
         atualiza_l2('G',dado);
         dado= TERMIO_GetChar();
         atualiza_l2('B',dado);
         PWM_CTRL |= PWM_CTRL_LDOK;
      }
    }
      
	}
	
}

void delay(void)
{
int16_t teste;
     for(i=0;i<500;i++)
    	{
    	for(j=0;j<10000;j++)
    		{
    		for(k=0;k<10000;k++)
    		{
    		teste=k;	
    		}
    		}		
    	}
	
}


void atualiza_l1(int8_t cor, int8_t intensidade)
{
  //int intens;
  switch(intensidade){
    case '0': intens=0; Print("Ok 0\r\n"); break;
    case '1': intens=10; Print("Ok 1\r\n"); break;
    case '2': intens=20; Print("Ok 2\r\n"); break;
    case '3': intens=30; Print("Ok 3\r\n"); break;
    case '4': intens=40; Print("Ok 4\r\n"); break;
    case '5': intens=50; Print("Ok 5\r\n"); break;
    case '6': intens=60; Print("Ok 6\r\n"); break;
    case '7': intens=70; Print("Ok 7\r\n"); break;
    case '8': intens=80; Print("Ok 8\r\n"); break; 
    case '9': intens=90; Print("Ok 9\r\n"); break;
    default: intens=-1;
  }
    if(intens!=-1){
      if(cor=='R'){PWM_VAL1=intens;Print("Ok R\r\n");} // pino9
      if(cor=='G'){PWM_VAL0=intens;Print("Ok G\r\n");} // pino11
      if(cor=='B'){PWM_VAL3=intens;Print("Ok B\r\n");} // pino 30
        
    }
 
}

void atualiza_l2(int8_t cor, int8_t intensidade)
{
  //int intens;
  switch(intensidade){
    case '0': intens=0; Print("Ok 0\r\n"); break;
    case '1': intens=10; Print("Ok 1\r\n"); break;
    case '2': intens=20; Print("Ok 2\r\n"); break;
    case '3': intens=30; Print("Ok 3\r\n"); break;
    case '4': intens=40; Print("Ok 4\r\n"); break;
    case '5': intens=50; Print("Ok 5\r\n"); break;
    case '6': intens=60; Print("Ok 6\r\n"); break;
    case '7': intens=70; Print("Ok 7\r\n"); break;
    case '8': intens=80; Print("Ok 8\r\n"); break; 
    case '9': intens=90; Print("Ok 9\r\n"); break;
    default: intens=-1;
  }
    if(intens!=-1){
      if(cor=='R'){PWM_VAL2=intens;Print("Ok R\r\n");} // pino32
      if(cor=='G'){PWM_VAL5=intens;Print("Ok G\r\n");} // pino34
      if(cor=='B'){PWM_VAL4=intens;Print("Ok B\r\n");} // pino36
        
    }
 
}

// End of "main.c"
